<?php
/*------------------------------------------------
 * Конвертер YML от prom.ua для rozetka.ua 2019-04-16
 * Copyright © FinBoss 2019
 * finboss.ua@gmail.com 
 *
 * выбор параметров
 *
 * License: Commercial open source software (COSS) 
 *------------------------------------------------
 */

@set_time_limit(0);

error_reporting (E_ALL);

header('Content-Type: text/html; charset=utf-8');

// контроль доступа по IP
$a_allow = false;
if (is_file('.allowed_ip')){
	$a_ips = file('.allowed_ip');
	
	foreach ($a_ips as $a_ip){
		$a_ip = trim($a_ip);
		if (strpos($a_ip, '*') !== false){
			
			// process 127.0.*.*
			
			$remote = explode('.', $_SERVER['REMOTE_ADDR']);
			$a = explode('.', $a_ip);
			
			$true_count = 0;
			for ($i=0;$i<4;$i++){
				switch ($i){
					case 0:
					case 1:
						if ($remote[$i] != $a[$i]){
							break 2;
						}else{
							$true_count++;
						}
						break;
					case 2:
					case 3:
						if ($a[$i] == '*'){
							// пропускаем
							$true_count++;
						}else{
							if ($remote[$i] != $a[$i]){
								break 2;
							}else{
								$true_count++;
							}
						}
						
				}
			}
			if ($true_count == 4){
				$a_allow = true;
				break;
			}
			
		}else{
			if ($_SERVER['REMOTE_ADDR'] == trim($a_ip)){
				$a_allow = true;
				break;
			}
		}
	}
	
}
if ($a_allow === false){
	die('доступ для IP '.$_SERVER['REMOTE_ADDR'].' заблокирован');
}

date_default_timezone_set ('Europe/Kiev');

include_once('rozetka.cfg.php');

$title = "Конвертер YML от prom.ua для rozetka.ua - выбор параметров";
	
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf8" >
<title><?php echo $title?></title>
<script language="javascript" type="text/javascript">
function checkAll( n, fldName ) {
  if (!fldName) {
     fldName = 'cb';
  }
	var f = document.adminForm;
	var c = f.toggle.checked;
	var n2 = 0;
	for (i=0; i < n; i++) {
		cb = eval( 'f.' + fldName + '' + i );
		if (cb) {
			cb.checked = c;
			n2++;
		}
	}
}
</script>
</head>
<body style="font-family:Trebuchet MS; font-size: 10pt;" bgcolor="#f5f8fb">

<table width="100%" bgcolor="#416e98">
<tr valign="middle">
<td><span style="font-size:25px; color:#FFF; font-family:Trebuchet MS"><?php echo $title?></span></td>
<td align="right"><span style="font-size:15px; color:#FFF; font-family:Trebuchet MS"></span></td>
</tr>
</table>

<?php 

	
	
	if (!is_file('input/prom.xml') OR (isset($_GET['mode']) AND $_GET['mode'] == 'reload')){

		// 'Файл input/prom.xml не найден - скачиваем';

		$string = curl_get_contents($site_protocol_select.'://'.$xml_link);
		
		if (strpos($string, 'Error: ') !== false){
			die("Ошибка: не удалось получить данные по ссылке ".$xml_link." ответ = $string ".date(" Y-m-d H:i:s"));
		}else if ($string == ''){
			die("Ошибка: не удалось получить данные по ссылке - получен пустой ответ".$xml_link.date(" Y-m-d H:i:s"));
		}else{
			$data = simplexml_load_string($string);
			if (!is_object ($data)){
				die("Ошибка: не удалось получить данные по ссылке ".$xml_link." ответ = $string ".date(" Y-m-d H:i:s"));
			}
			file_put_contents('input/prom.xml', $string);
			$size = filesize('input/prom.xml');
		}
	}else{
		
		$size = filesize('input/prom.xml');
		$data = simplexml_load_file('input/prom.xml');
		if (is_object($data)){
			
		}else{
			die ('Файл input/prom.xml содержит ошибки');
			
		}
		
	}
	
	$date = $data->attributes()->date;
	$categories_in_file = $data->shop->categories->category;
	$offers = $data->shop->offers->offer;
	echo "<br/><center>\r\n";
	echo "Используется входной файл, сгенерированный $date <br/>\r\n";
	echo "Размер файла $size <br/>\r\n";
	echo "Всего категорий ".count($categories_in_file)." <br/>\r\n";
	echo "Всего товаров ".count($offers)." <br/><br/>\r\n";
	
	echo "<a href='set_categories.php?mode=reload'><b>ОБНОВИТЬ</b></a> <br/><br/>\r\n";
	echo "<hr/>\r\n";
	echo "</center>\r\n";

	unset($string);
	unset($data);
	unset($categories_in_file);
	
	
	if (isset($_POST['save'])){
		
		$parameters = $dop_parameters = array();
		if (isset($_POST['parameter'])){
			foreach ($_POST['parameter'] as $parameter_id => $parameter_name){
				$parameters[$parameter_name] = 1;
			}
		}
		
		if (isset($_POST['dop_parameter'])){
			foreach ($_POST['dop_parameter'] as $parameter_id => $parameter_name){
				if (!isset($parameters[$parameter_name])){
					$dop_parameters[$parameter_name] = 1;
				}
			}
		}
		
		$saved = array();
		$saved['parameters'] = $parameters;
		$saved['dop_parameters'] = $dop_parameters;
		
		file_put_contents('tmp/parameters.json', json_encode($saved));
		
	}
	
	if (is_file('tmp/parameters.json')){
		$saved = json_decode(file_get_contents('tmp/parameters.json'), true);
		$parameters = $saved['parameters'];
		$dop_parameters = $saved['dop_parameters'];
	}else{
		$parameters = $dop_parameters = array();
	}
	
	$parameters_in_file = array();
	foreach ($offers as $item){
		
		if (isset($item->param)){
		
			if (count($item->param) > 1){
			
				foreach ($item->param as $param){
					$param_name = (string)$param->attributes()->name;
					if (!isset($parameters_in_file[$param_name])){
						$parameters_in_file[$param_name] = (string)$item->name;;
					}
				}
			
			}else{
				
				$param_name = (string)$item->param->attributes()->name;
				
				if (!isset($parameters_in_file[$param_name])){
					$parameters_in_file[$param_name] = (string)$item->name;
				}
			}
		}
	}
	
	ksort($parameters_in_file);
	
?>


<form method="post" name="adminForm">
<center>
<h2>Параметры</h2>
<h4>(отметьте выгружаемые параметры товаров)</h4>
<table width="50%" border="1" style="border-collapse:collapse;border-color:black;">
<tr>

<th>Параметр</th>
<th>Доп.<br/>параметр</th>
<th></th>
</tr>

<tr>
	<td align="center" colspan=3>
		<input type="submit" name="save" value="Сохранить" />
	</td>
</tr>

<?php 

	$checkbox_count = $dop_checkbox_count = 0;

	foreach ($parameters_in_file as $parameter_name => $dummy){
		
		if (isset($parameters[$parameter_name])){
			$checked = ' checked ';
		}else{
			$checked = '';
		}
		
		if (isset($dop_parameters[$parameter_name])){
			$dop_checked = ' checked ';
		}else{
			$dop_checked = '';
		}
	
		$checkbox_count++;
		$dop_checkbox_count++;
?>

<tr>
<td align=center><input type="checkbox" id="cb<?php echo $checkbox_count; ?>" name="parameter[<?php echo $checkbox_count; ?>]" value="<?php echo $parameter_name?>" <?php echo $checked?> /></td>
<td align=center><input type="checkbox" id="dop<?php echo $checkbox_count; ?>" name="dop_parameter[<?php echo $dop_checkbox_count; ?>]" value="<?php echo $parameter_name?>" <?php echo $dop_checked?> /></td>
<td> <?php echo $parameter_name?> </td>
</tr>
<?php
			
		}
?>
<tr>
	<td align="center">
		<input type="checkbox" name="toggle" class="delete" onclick="checkAll(<?php echo ($checkbox_count+1); ?>)" /> 
	</td>
	<td align="left" colspan=2>Все выделить/снять выделение	</td>
	
</tr>

<tr>
	<td align="center" colspan=3>
		<input type="submit" name="save" value="Сохранить" />
	</td>
</tr>
</table>
</center>
</form>
</body>
</html>
